---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：30-API Routes

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **C-13**：res.revalidate()によるISRオンデマンド再検証の具体的実装

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/route-modules/pages-api/module.ts` - PagesAPIRouteModuleメイン実装
- E-02: `packages/next/src/server/api-utils/node/api-resolver.ts` - apiResolver実装
- E-03: `packages/next/src/server/api-utils/index.ts` - APIユーティリティ
- E-04: `packages/next/src/server/api-utils/node/parse-body.ts` - ボディパース
- E-05: `packages/next/src/server/api-utils/node/try-get-preview-data.ts` - プレビューモード
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | default関数のエクスポートが必須 | E-01 (118-122行目) | ○ |
| C-02 | PagesAPIRouteModule.render()がapiResolverWrappedに委譲 | E-01 (136-161行目) | ○ |
| C-03 | wrapApiHandlerでapiResolverをラップ | E-01 (124-128行目) | ○ |
| C-04 | apiResolverにクエリ、ユーザーモジュール、設定を渡す | E-01 (142-160行目) | ○ |
| C-05 | 204/304ステータスでボディを送信しない | E-02 (65-78行目) | ○ |
| C-06 | ETag自動生成 | E-02 (92-95行目) | ○ |
| C-07 | レスポンスサイズ制限（RESPONSE_LIMIT_DEFAULT） | E-02 (45-50行目) | ○ |
| C-08 | Streamレスポンスのサポート | E-02 (82-87行目) | ○ |
| C-09 | JSON/Buffer/文字列レスポンスの自動処理 | E-02 (90-100行目) | ○ |
| C-10 | Content-Type自動設定 | E-02 (83-85行目, 98-99行目) | ○ |
| C-11 | PagesAPIRouteHandlerContext型定義 | E-01 (35-102行目) | ○ |
| C-12 | multiZoneDraftModeサポート | E-01 (95-96行目, 153行目) | ○ |
| C-13 | res.revalidate()によるISRオンデマンド再検証 | **根拠なし** (apiResolver内の具体的revalidateヘルパー未確認) | △ |

## 4) 不足情報（Unknown / Missing）
- res.revalidate()ヘルパーメソッドの具体的実装箇所
  - 候補：`packages/next/src/server/api-utils/node/api-resolver.ts`内のNextApiResponse拡張

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PagesAPIRouteModuleの構造は明確に確認済み
- 0: 低リスク - apiResolverのレスポンス処理（sendData）は確認済み
- 0: 低リスク - レスポンスサイズ制限とETag生成は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] PagesAPIRouteModule.render()からapiResolverWrappedへの委譲が正確か確認
- [ ] sendData関数のレスポンス処理ロジックが網羅的か確認
- [ ] res.revalidate()ヘルパーの実装箇所を確認
